



<html>
<head>
  <title>javabog.dk -  - Definition af klasser</title>
  <link rev="stylesheet" type="text/css" href="../typografi.css">
  <meta name="description" content="Lrebog i Java. Af Jacob Nordfalk. Udkommet hos Forlaget Globe">
  <meta name="keywords" content="designmnster, programmering, OOP, objekter, klasser, objektorienteret programmering, Java, JSP, lrebog, UML, IT">
</head>
<body bgcolor="#ffffff">



<a href='http://javabog.dk/'>javabog.dk</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel3.jsp'>&lt;&lt; forrige</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='indhold.jsp'>indhold</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel5.jsp'>n&aelig;ste &gt;&gt;</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kode/'>programeksempler</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='../index_OOP.html'>om bogen</a>

<H1 CLASS="western" STYLE="">4 <a name='afsn4'></a>Definition af
klasser</H1>
<P CLASS="kapiteloversigt-western">Indhold:</P>
<UL>
  <LI><P CLASS="kapiteloversigt-western">Definere egne klasser (typer
  af objekter)</P>
  <LI><P CLASS="kapiteloversigt-western">Definere konstrukt&oslash;rer,
  objektvariabler og metoder</P>
  <LI><P CLASS="kapiteloversigt-western">Definition af klasserne Boks,
  Terning, Rafleb&aelig;ger, Person og Konto</P>
  <LI><P CLASS="kapiteloversigt-western">N&oslash;gleordet this</P>
</UL>
<P CLASS="kapiteloversigt-western">Kapitlet foruds&aelig;ttes i
resten af bogen.</P>
<P CLASS="kapiteloversigt-western">Foruds&aelig;tter <a href='kapitel3.jsp'>kapitel 3</a>, Objekter.</P>


<P CLASS="western" STYLE="">Er man i gang
med et st&oslash;rre program, vil man have brug for at definere sine
egne specialiserede klasser. Et regnskabsprogram kunne f.eks.
definere en Konto-klasse. Ud fra Konto-klassen ville der blive
skabt et antal konto-objekter, svarende til de konti, der skulle
administreres. 
</P>
<P CLASS="western">I dette kapitel ser vi p&aring;, hvordan man selv
definerer sine egne klasser. Vi minder om, at</P>
<BLOCKQUOTE CLASS="definition-western">En klasse er en skabelon, som
man kan danne objekter ud fra</BLOCKQUOTE>
<BLOCKQUOTE CLASS="definition-western">Klassen beskriver variabler og
metoder, der kendetegner objekterne</BLOCKQUOTE>
<BLOCKQUOTE CLASS="definition-western">Et objekt er en konkret
forekomst (instans) af klassen</BLOCKQUOTE>
<P CLASS="western">N&aring;r man programmerer objektorienteret,
samler man data i selvst&aelig;ndige objekter og definerer
metoder, som arbejder p&aring; disse data i objekterne.</P>
<H2 CLASS="western">4.1 <a name='afsn4.1'></a>En Boks-klasse</SPAN></H2>
<P CLASS="western">Lad os tage et eksempel p&aring; en
klassedefinition:</P>
<P CLASS="western" ALIGN=CENTER><IMG SRC="bog5_html_3354f2f8.gif" NAME="Objekt54" ALIGN=BOTTOM></P>
<P CLASS="western">Vi definerer klassen Boks, som indeholder tre
variabler, nemlig bredde, h&oslash;jde og l&aelig;ngde. Derudover
definerer vi metoden volumen(), som arbejder p&aring; disse data.
Metoden returnerer en double og har ingen parametre.</P>
<PRE CLASS="kode-western">public class Boks
{
  double l&aelig;ngde;
  double bredde;
  double h&oslash;jde;

  double volumen()
  {
    double vol;
    vol = l&aelig;ngde*bredde*h&oslash;jde;
    return vol; 
  }
}</PRE><H3 CLASS="western">
4.1.1 <a name='afsn4.1.1'></a>Variabler</H3>
<P CLASS="western">Variablerne bredde, h&oslash;jde og l&aelig;ngde
kaldes ogs&aring; objektvariabler, fordi hvert Boks-objekt har en af
hver. 
</P>
<BLOCKQUOTE CLASS="definition-western">Objektvariabler erkl&aelig;res
direkte i klassen uden for metoderne<A CLASS="sdfootnoteanc" NAME="sdfootnote1anc" HREF="#sdfootnote1sym"><SUP>1</SUP></A></BLOCKQUOTE>
<P CLASS="western" STYLE="; ">
Vi kan lave et Boks-objekt, boksobjekt med new:</P>
<PRE CLASS="kode-western" STYLE="">    Boks boksobjekt;
    boksobjekt = new Boks();</PRE>
<P CLASS="western" STYLE="">Nu er der oprettet
et Boks-objekt i lageret, der s&aring;ledes har en  l&aelig;ngde-, en
bredde- og en h&oslash;jde-variabel (hver med v&aelig;rdien 0).</P>
<P CLASS="western">Variablen vol kaldes en lokal variabel, fordi den
er erkl&aelig;ret lokalt i volumen()-metoden. 
</P>
<BLOCKQUOTE CLASS="definition-western">En variabel erkl&aelig;ret
inde i en metode kaldes en lokal variabel</BLOCKQUOTE>
<BLOCKQUOTE CLASS="definition-western">Lokale variabler eksisterer
kun, s&aring; l&aelig;nge metoden, hvori de er erkl&aelig;ret,
udf&oslash;res</BLOCKQUOTE>
<P CLASS="western">Modsat h&oslash;jde, l&aelig;ngde og bredde
begynder vol-variabler alts&aring; ikke at eksistere, bare fordi vi
har skabt en Boks<A CLASS="sdfootnoteanc" NAME="sdfootnote2anc" HREF="#sdfootnote2sym"><SUP>2</SUP></A>.</P>
<H3 CLASS="western">4.1.2 <a name='afsn4.1.2'></a>Brug af klassen</H3>
<P CLASS="western">Objekter af klassen Boks kan f.eks. benyttes p&aring;
f&oslash;lgende m&aring;de:</P>
<PRE CLASS="kode-western">public class BenytBoks
{
  public static void main(String[] arg)
  {
    double rumfang;

<B>    Boks boksobjekt;</B>
<B>    boksobjekt = new Boks();</B>
<B>    boksobjekt.l&aelig;ngde= 12.3;</B>
<B>    boksobjekt.bredde= 2.22;</B>
<B>    boksobjekt.h&oslash;jde = 6.18;</B>
<B>    rumfang = boksobjekt.volumen();</B>
    System.out.println(&quot;Boksens volume: &quot;+ rumfang);
  }
}</PRE>
<HR>
<PRE CLASS="kode-western">Boksens volume: 168.75108</PRE><P CLASS="western">
Som det ses, er det klassen BenytBoks, der indeholder main()-metoden.
Der skal v&aelig;re &eacute;n og kun &eacute;n klasse med en
main()-metode i et program. En s&aring;dan &quot;main-klasse&quot;
bruges ikke til at definere objekttyper med - kun til at angive, hvor
programmet skal startes<A CLASS="sdfootnoteanc" NAME="sdfootnote3anc" HREF="#sdfootnote3sym"><SUP>3</SUP></A>.</P>
<P CLASS="western">I f&oslash;lgende s&aelig;tninger (i klassen
BenytBoks) s&aelig;ttes det nyoprettede Boks-objekts variabler:</P>
<PRE CLASS="kode-western">  boksobjekt.l&aelig;ngde= 12.3;
  boksobjekt.bredde= 2.22;
  boksobjekt.h&oslash;jde = 6.18;</PRE><P CLASS="western">
I den efterf&oslash;lgende s&aelig;tning:</P>
<PRE CLASS="kode-western">  rumfang = boksobjekt.volumen();</PRE><P CLASS="western">
kaldes metoden volumen() i Boks-objektet, der udregner rumfanget ud
fra variablerne, som er blevet tilf&oslash;rt data i linjerne
ovenfor. Metoden returnerer en double - denne l&aelig;gges over i
rumfang-variablen, som udskrives.</P>
<H3 CLASS="western">4.1.3 <a name='afsn4.1.3'></a>Metodedefinition</H3>
<P CLASS="western">N&aring;r vi definerer en metode, giver vi den et
hoved og en krop.</P>
<P CLASS="western"><B>Hovedet</B> ligner den m&aring;de, vi tidligere
har set metoder opremset p&aring;. Metodehovedet fort&aelig;ller
metodens navn, returtype og hvilke parametre metoden eventuelt har:</P>
<PRE CLASS="kode-western">  double volumen()</PRE>
<P CLASS="western" STYLE=""><B>Kroppen</B>
kommer lige under hovedet:</P>
<PRE CLASS="kode-western">  {
    double vol;
    vol = l&aelig;ngde*bredde*h&oslash;jde;
    return vol; 
  }</PRE><P CLASS="western">
I kroppen st&aring;r der, hvad der skal ske, n&aring;r metoden
kaldes. Her st&aring;r alts&aring;, at n&aring;r metoden volumen()
kaldes, bliver der f&oslash;rst oprettet en lokal variabel, vol.
Denne bliver tildelt produktet af de tre variabler l&aelig;ngde,
bredde og h&oslash;jde. Den sidste linje i kroppen fort&aelig;ller,
at resultatet af vol bliver givet tilbage (returneret) til der, hvor
metoden blev kaldt.</P>
<BLOCKQUOTE CLASS="definition-western">En metodekrop udf&oslash;res,
n&aring;r metoden kaldes</BLOCKQUOTE>
<P CLASS="western">Variablerne l&aelig;ngde, bredde og h&oslash;jde,
som kroppen bruger, er dem, der findes i netop det objekt, som
volumen()-metoden blev kaldt p&aring;. 
</P>
<P CLASS="western">Lad os kigge p&aring; en stump af BenytBoks:</P>
<PRE CLASS="kode-western">    boksobjekt.l&aelig;ngde= 12.3;
    boksobjekt.bredde= 2.22;
    boksobjekt.h&oslash;jde= 6.18;
    rumfang = boksobjekt.volumen();</PRE><P CLASS="western">
Her f&aring;r det Boks-objekt, som boksobjekt refererer til, sat sine
variabler og n&aring;r volumen() derefter kaldes p&aring; objektet,
vil l&aelig;ngde, bredde og h&oslash;jde have disse v&aelig;rdier.
rumfang bliver sat til den v&aelig;rdi, vol har i return-linjen og
vol nedl&aelig;gges (da den er en lokal variabel).</P>
<BLOCKQUOTE CLASS="definition-western">En return-s&aelig;tning
afslutter udf&oslash;relsen af metodekroppen og leverer en v&aelig;rdi
tilbage til kalderen</BLOCKQUOTE>
<H3 CLASS="western">4.1.4 <a name='afsn4.1.4'></a>Flere objekter</H3>
<P CLASS="western">Herunder opretter vi to bokse og udregner deres
forskel i rumfang. Hver boks er et aftryk af Boks-klassen forst&aring;et
p&aring; den m&aring;de, at de hver indeholder deres egne s&aelig;t
variabler. Variablen bredde kan s&aring;ledes have forskellige
v&aelig;rdier i hvert objekt.</P>
<PRE CLASS="kode-western">public class BenytBokse
{
  public static void main(String[] arg)
  {
    Boks boks1, boks2;
<B>    boks1 = new Boks();</B>
<B>    boks2 = new Boks();</B>

<B>    boks1.l&aelig;ngde= 12.3;</B>
<B>    boks1.bredde= 2.22;</B>
<B>    boks1.h&oslash;jde= 6.18;</B>

<B>    boks2.l&aelig;ngde= 13.3;</B>
<B>    boks2.bredde= 3.33;</B>
<B>    boks2.h&oslash;jde= 7.18;</B>

    double v1, v2;

<B>    v1 = boks1.volumen();</B>
<B>    v2 = boks2.volumen();</B>

    System.out.println(&quot;Volumenforskel: &quot;+ (<B>v2 - v1</B>));
  }
}</PRE>
<HR>
<PRE CLASS="kode-western">Volumenforskel: 149.24394</PRE><P CLASS="western">
N&aring;r vi kalder volumen() p&aring; boks1 og boks2, er det s&aring;ledes
to forskellige s&aelig;t l&aelig;ngde-, h&oslash;jde- og
bredde-variabler, der bliver brugt til beregningen, n&aring;r
volumen()'s krop udf&oslash;res.</P>
<H2 CLASS="western">4.2 <a name='afsn4.2'></a>Indkapsling</SPAN></H2>
<P CLASS="western">Indkapsling (eng.: encapsulation) af data og
metoder i objekter betyder, at man ikke lader andre bruge objekterne
helt efter eget forgodtbefindende. Man g&oslash;r visse dele af
objekterne utilg&aelig;ngelige uden for klassens metoder. Herved
s&aelig;tter man nogle regler op for, hvordan man kan benytte
objekterne.</P>
<P CLASS="western">Hvorfor overhovedet indkapsle (skjule) variabler?</P>
<P CLASS="western">Indkapsling i klasser er vigtig, n&aring;r
programmerne bliver store og komplekse. Hvis det er muligt at &aelig;ndre
data i en klasse, kan det f&oslash;re til situationer, som
kommer ud af kontrol i store komplekse systemer. N&aring;r data er
indkapslet kan de ikke &aelig;ndres direkte udefra, og man m&aring; i
stedet definere metoder til at &aelig;ndre i data p&aring;. I
metoderne kan man sikre sig mod vanvittige overgreb p&aring;
data ved at tilf&oslash;re logik, der sikrer, at variablerne er
konsistente.</P>
<P CLASS="western">I ovenst&aring;ende eksempel kan man for eksempel
s&aelig;tte h&oslash;jden af en boks til et negativt tal. Sp&oslash;rger
man derefter p&aring; volumen(), vil man f&aring; et negativt svar!
Det kr&aelig;ver ikke meget fantasi at forestille sig, hvordan
s&aring;danne fejl kunne g&oslash;re et program ubrugeligt. T&aelig;nk
for eksempel p&aring; pakkepost-omdeling, hvis et af Post Danmarks
programmer p&aring;stod, at der nemt kunne v&aelig;re 10000 pakker p&aring;
hver <I>minus</I> en kubikmeter og 10001 pakker p&aring; hver plus en
kubikmeter i &eacute;n postvogn... endda med flere kubikmeter til
overs til anden post!</P>
<P CLASS="western">Med indkapsling opn&aring;r man, at objekterne
altid er konsistente, fordi objekterne selv s&oslash;rger for, at
deres variabler har fornuftige v&aelig;rdier.</P>
<P CLASS="western">Man styrer adgangen til en variabel eller metode
med n&oslash;gleordene public og private<A CLASS="sdfootnoteanc" NAME="sdfootnote4anc" HREF="#sdfootnote4sym"><SUP>4</SUP></A>:</P>
<BLOCKQUOTE CLASS="definition-western">public betyder &quot;adgang
for alle&quot;</BLOCKQUOTE>
<BLOCKQUOTE CLASS="definition-western">private betyder &quot;kun
adgang fra samme klasse&quot;</BLOCKQUOTE>
<P CLASS="western" STYLE="; ">
Herunder ses en modificeret version af eksemplet med Boks- og
BenytBoks-klassen, men nu er variablerne erkl&aelig;ret private. 
</P>
<PRE CLASS="kode-western" STYLE="">public class Boks2
{
<B>  private double l&aelig;ngde;</B>
<B>  private double bredde;</B>
<B>  private double h&oslash;jde;</B>

<B>  public void s&aelig;tM&aring;l(double lgd, double b, double h)</B>
  {
    if (lgd&lt;=0 || b&lt;=0 || h&lt;=0)
    {
      l&aelig;ngde = 10.0;
      bredde = 10.0;
      h&oslash;jde  = 10.0;
       System.out.println(&quot;Ugyldige m&aring;l. Bruger standardm&aring;l.&quot;);
    } else {
      l&aelig;ngde = lgd;
      bredde = b;
      h&oslash;jde  = h;
    }
  }

<B>  public double volumen()</B>
  {
    double vol;
    vol = l&aelig;ngde*bredde*h&oslash;jde;
    return vol; 
  }
}</PRE><P CLASS="western" STYLE="; ">
Figuren illustrerer klassen i UML-notationen. Bem&aelig;rk, at
variablerne er private, s&aring; de har et - foran, mens metoderne,
som kan ses udefra (public), har et + foran:</P>
<P ALIGN=CENTER STYLE="margin-top: 0.11cm; margin-bottom: 0.11cm"><IMG SRC="bog5_html_7571b3b1.gif" NAME="Objekt55" ALIGN=MIDDLE></P>
<P CLASS="western">Nu da variablerne bredde, h&oslash;jde og l&aelig;ngde
er <SPAN STYLE="font-weight: medium">erkl&aelig;ret private, er det
ulovligt at &aelig;ndre dem &quot;udefra&quot; i vores
</SPAN>BenytBoks-program.</P>
<P CLASS="western">Til geng&aelig;ld har vi defineret metoden
s&aelig;tM&aring;l(), som man skal kalde for at s&aelig;tte
variablerne. 
</P>
<P CLASS="western">Da den eneste m&aring;de at &aelig;ndre data p&aring;
er ved at kalde metoden s&aelig;tM&aring;l(), kan vi der indl&aelig;gge
&oslash;nsket logik - for eksempel sikre os mod 0 (nul) eller
negative v&aelig;rdier.</P>
<PRE CLASS="kode-western">public class BenytBoks2
{
  public static void main(String[] arg)
  {
    Boks2 <B>enBoks = new Boks2()</B>;

<I>    //ulovligt: enBoks.l&aelig;ngde= 12.3;</I>
<I>    //ulovligt: enBoks.bredde= 2.22;</I>
<I>    //ulovligt: enBoks.h&oslash;jde= 6.18;</I>

<B>    enBoks.s&aelig;tM&aring;l( 2.0, 2.5, 1.5);</B>

    System.out.println(&quot;Volumen er: &quot;+ enBoks.volumen());

<B>    enBoks.s&aelig;tM&aring;l(-2.0, 0.0, 1.0);</B>

    System.out.println(&quot;Volumen er: &quot;+ enBoks.volumen());

<B>    enBoks.s&aelig;tM&aring;l( 2.0, 3.0 ,1.0);</B>

    System.out.println(&quot;Volumen er: &quot;+ enBoks.volumen());
  }
}</PRE>
<HR>
<PRE CLASS="kode-western">Volumen er: 7.5
Ugyldige m&aring;l. Bruger standardm&aring;l.
Volumen er: 1000.0
Volumen er: 6.0</PRE>
<P CLASS="western">En anden fordel ved indkapsling er, at man bliver
uafh&aelig;ngig af, hvordan data er repr&aelig;senteret internt. Man
kunne f.eks. senere &aelig;ndre Boks-klassen, s&aring; den kun
lagrede volumen (beregnet allerede i s&aelig;tM&aring;l()) i stedet
for l&aelig;ngde, bredde og h&oslash;jde..</P>

<H2 CLASS="western" STYLE="">4.3 <a name='afsn4.3'></a>Konstrukt&oslash;rer</SPAN></H2>
<P CLASS="western">En konstrukt&oslash;r (eng.: constructor) er en
speciel metode, der har samme navn som klassen. Den kaldes automatisk
ved oprettelse af et objekt med 'new'-operatoren og benyttes oftest
til at klare forskellige former for initialisering af det nye objekt.</P>
<P CLASS="western">Som vi s&aring; i forrige kapitel (i tilf&aelig;ldet
med Rectangle, Point og Date), kan man have flere konstrukt&oslash;rer
for en klasse, bare parameterlisterne er forskellige.</P>
<P CLASS="western">Her kommer et eksempel<A CLASS="sdfootnoteanc" NAME="sdfootnote5anc" HREF="#sdfootnote5sym"><SUP>5</SUP></A>
me<IMG SRC="bog5_html_m616a5fce.gif" NAME="Objekt56" ALIGN=RIGHT>d
nogle konstrukt&oslash;rer:</P>
<PRE CLASS="kode-western"><I>/** En boks med en l&aelig;ngde, bredde og h&oslash;jde */</I>
public class Boks3 
{
  private double l&aelig;ngde;
  private double bredde;
  private double h&oslash;jde;

<I>  /** konstrukt&oslash;r der opretter en standardboks */</I>
<B>  public Boks3()</B>
  {
    System.out.println(&quot;Standardboks oprettes&quot;);
    s&aelig;tM&aring;l(10, 10, 10);
  }

<I>  /** en anden konstrukt&oslash;r der f&aring;r bredde, h&oslash;jde og l&aelig;ngde */</I>
<B>  public Boks3(double lgd, double b, double h)</B>
  {
    System.out.println(&quot;Boks oprettes med lgd=&quot;+lgd+&quot; b=&quot;+b+&quot; h=&quot;+h);
    s&aelig;tM&aring;l(lgd,b,h);
  }

<I>  /** s&aelig;tter boksens bredde, h&oslash;jde og l&aelig;ngde */</I>
  public void s&aelig;tM&aring;l(double lgd, double b, double h)
  {
    if (lgd&lt;=0 || b&lt;=0 || h&lt;=0) 
    {
       System.out.println(&quot;Ugyldige m&aring;l. Bruger standardm&aring;l.&quot;);
      l&aelig;ngde = 10.0;
      bredde = 10.0;
      h&oslash;jde  = 10.0;
    } else {
      l&aelig;ngde = lgd;
      bredde = b;
      h&oslash;jde  = h;
    }
  }

<I>  /** udregner boksens rumfang */</I>
  public double volumen()
  {
    double vol = l&aelig;ngde*bredde*h&oslash;jde ;
    return vol;
  }
}</PRE><P CLASS="western">
Bem&aelig;rk: 
</P>
<BLOCKQUOTE CLASS="definition-western">En konstrukt&oslash;r erkl&aelig;res
som en metode med samme navn som klassen</BLOCKQUOTE>
<BLOCKQUOTE CLASS="definition-western">En konstrukt&oslash;r har
ingen returtype - ikke engang 'void'</BLOCKQUOTE>
<P CLASS="western">I ovenst&aring;ende eksempel er der defineret to
konstrukt&oslash;rer:</P>
<PRE CLASS="kode-western">  public Boks3()
  public Boks3(double lgd, double b, double h)</PRE>

<P CLASS="western">Vi kan afpr&oslash;ve Boks3 med:</P>
<PRE CLASS="kode-western">public class BenytBoks3
{
  public static void main(String[] arg)
  {
    Boks3 enBoks;
    enBoks = <B>new Boks3()</B>;             <I>// brug konstrukt&oslash;ren uden parametre</I>
    System.out.println(&quot;Volumen er: &quot;+ enBoks.volumen());

    Boks3 enAndenBoks;    
    enAndenBoks = <B>new Boks3(5,5,10)</B>;  <I>// brug den anden konstrukt&oslash;r</I>
    System.out.println(&quot;Volumen er: &quot;+ enAndenBoks.volumen());
  }
}</PRE>
<HR>
<PRE CLASS="kode-western" STYLE="">Standardboks oprettes
Volumen er: 1000.0
Boks oprettes med lgd=5.0 b=5.0 h=10.0
Volumen er: 250.0</PRE><H3 CLASS="western">
4.3.1 <a name='afsn4.3.1'></a>Standardkonstrukt&oslash;rer</H3>
<P CLASS="western">N&aring;r vi i de foreg&aring;ende eksempler
(f.eks. Boks2) ikke har benyttet en konstrukt&oslash;r, er det fordi
Java, hvis ikke en konstrukt&oslash;r er erkl&aelig;ret, selv
erkl&aelig;rer en tom standardkonstrukt&oslash;r uden parametre. Dvs.
Java i Boks2's tilf&aelig;lde usynligt har defineret konstrukt&oslash;ren:</P>
<PRE CLASS="kode-western">public Boks2()
{
}</PRE><P CLASS="western">
Denne konstrukt&oslash;r har vi kaldt, hver gang vi har oprettet en
boks med 'new Boks2()'. 
</P>
<BLOCKQUOTE CLASS="definition-western">Der kaldes altid en
konstrukt&oslash;r, n&aring;r et objekt oprettes</BLOCKQUOTE>
<BLOCKQUOTE CLASS="definition-western">Standardkonstrukt&oslash;ren
genereres automatisk, hvis der ikke er andre konstrukt&oslash;rer
i klassen</BLOCKQUOTE>
<P CLASS="western">En standardkonstrukt&oslash;r genereres kun, hvis
der ikke er andre konstrukt&oslash;rer i klassen.</P>
<P CLASS="western">Hvis vi ikke havde defineret en konstrukt&oslash;r
uden parametre i Boks3, ville overs&aelig;tteren i BenytBoks3 brokke
sig over, at denne type konstrukt&oslash;r ikke fandtes:</P>
<PRE CLASS="western">  BenytBoks3.java:6: No constructor matching Boks3() found in class Boks3.
                  enBoks = new Boks3();</PRE>
<H3 CLASS="western">4.3.2 <a name='afsn4.3.2'></a>Opgaver</H3>
<OL>
  <LI><P CLASS="western">Defin&eacute;r klassen Pyramide. Objekterne
  skal have variablerne <I>side</I> og <I>h&oslash;jde</I> (defin&eacute;r
  en konstrukt&oslash;r) og en metode til at udregne volumen
  (side*side*h&oslash;jde/4). <BR>Skriv en BenytPyramider, som
  opretter 3 pyramider og udregner volumen af dem.</P>
  <LI><P CLASS="western">Ret Boks3 til ogs&aring; at have variablen
  massefylde og defin&eacute;r en ekstra konstrukt&oslash;r, der ogs&aring;
  f&aring;r massefylden overf&oslash;rt (den oprindelige konstrukt&oslash;r
  med lgd, b og h kan s&aelig;tte massefylden til 1). Lav ogs&aring;
  metoder til at s&aelig;tte massefylden, s&aelig;tMassefylde(double
  m), og udregne v&aelig;gten, v&aelig;gt(). Afpr&oslash;v, om
  det virker (test din klasse med en &aelig;ndret udgave af
  BenytBoks3).</P>
</OL>

<H2 CLASS="western" STYLE="">4.4 <a name='afsn4.4'></a>En
Terning-klasse</SPAN></H2>
<P CLASS="western">Lad os tage et andet eksempel, en terning. Den
vigtigste egenskab ved en terning er dens v&aelig;rdi (dvs. antallet
af &oslash;jne p&aring; siden, der vender opad lige nu) mellem 1 og
6.</P>
<P CLASS="western" ALIGN=CENTER><IMG SRC="bog5_html_60ce82b4.gif" NAME="Objekt57" ALIGN=BOTTOM></P>
<PRE CLASS="kode-western"><I>/** En klasse der beskriver 6-sidede terninger */</I>
public class Terning
{
  <I>/** antallet af &oslash;jne p&aring; den side p&aring; terningen, der vender opad lige nu */</I>
<B>  public int v&aelig;rdi;</B>

  <I>/** konstrukt&oslash;r der opretter en terning */</I>
<B>  public Terning()</B>
  {
    kast(); <I>// kald kast() der s&aelig;tter v&aelig;rdi til noget fornuftigt</I>
  }

  <I>/** kaster terningen, s&aring; den f&aring;r en anden v&aelig;rdi */</I>
<B>  public void kast()</B>
  {
    <I>// find en tilf&aelig;ldig side</I>
    double tilf&aelig;ldigtTal = Math.random();
    v&aelig;rdi = (int) (tilf&aelig;ldigtTal * 6 + 1);
  }

  <I>/** giver en beskrivelse af terningen som en streng */</I>
<B>  public String toString()</B>
  {
    String svar = &quot;&quot;+v&aelig;rdi;  <I>// v&aelig;rdi som streng, f.eks. &quot;4&quot;</I>
    return svar;
  }
}</PRE>
<P CLASS="western">Her er et program, der bruger et Terning-objekt
til at sl&aring; med, indtil vi f&aring;r en 6'er:</P>
<PRE CLASS="kode-western">public class BenytTerning
{
  public static void main(String[] arg)
  {
    Terning t;
    t = new Terning();  <I>// opret terning</I>

<I>    // Sl&aring; nu med terningen indtil vi f&aring;r en sekser</I>
    boolean sekser = false;
    int antalKast = 0;

    while (sekser==false)
    {
      t.kast();
      antalKast = antalKast + 1;
      System.out.println(&quot;kast &quot;+antalKast+&quot;: &quot;+t.v&aelig;rdi);
      if (t.v&aelig;rdi == 6) sekser = true;
    }

    System.out.println(&quot;Vi slog en 6'er efter &quot;+antalKast+&quot; slag.&quot;);
  }
}</PRE>
<HR>
<PRE CLASS="kode-western" STYLE="; ">kast 1: 4
kast 2: 2
kast 3: 6
Vi slog en 6'er efter 3 slag.</PRE><H3 CLASS="western">
4.4.1 <a name='afsn4.4.1'></a>Opgaver</H3>
<OL>
  <LI><P CLASS="western">Skriv et program, der rafler med to
  terning-objekter, indtil der sl&aring;s en 6'er.</P>
  <LI><P CLASS="western">Skriv et program, der rafler med fire
  terninger, indtil der sl&aring;s tre eller fire 6'ere. Udskriv
  antal &oslash;jne for hver terning.</P>
  <LI><P CLASS="western">Skriv et program, der rafler med 12 terninger
  og hver gang udskriver &oslash;jnene, summen af &oslash;jnene og
  hvor mange 6'ere der kom. Brug ArrayList-klassen til at holde styr
  p&aring; terningerne.</P>
  <LI><P CLASS="western">Lav en Moent-klasse, der repr&aelig;senterer
  en m&oslash;nt med 2 sider (du kan tage udgangspunkt i
  Terning.java). Lav metoden krone(), der returnerer true eller false.
  Lav et program, der kaster en m&oslash;nt 100 gange og t&aelig;ller
  antal gange, det fik krone.</P>
</OL>
<H2 CLASS="western">4.5 <a name='afsn4.5'></a>Relationer mellem objekter</SPAN></H2>
<P CLASS="western">Indtil nu har alle vore objekter haft simple typer
som variabler. Nu vil vi se p&aring; objekter, der har andre objekter
som variabler (dvs. de har referencer til andre objekter).</P>
<H3 CLASS="western">4.5.1 <a name='afsn4.5.1'></a>En Rafleb&aelig;ger-klasse</H3>
<P CLASS="western">N&aring;r man laver et st&oslash;rre program,
bliver det ofte n&oslash;dvendigt at uddelegere nogle af opgaverne
fra hovedprogrammet til andre dele af programmet. I vores tilf&aelig;lde
kunne vi godt lave et lille terningspil direkte fra main(), men hvis
vi skulle lave f.eks. et yatzy- eller matadorspil, ville det
blive besv&aelig;rligt, at skulle holde rede p&aring; hver enkelt
terning (og alle de andre objekter) p&aring; den m&aring;de. Hver
gang en spiller kaster med terningerne, skal man f&oslash;rst kaste
hver enkelt terning, hvorefter man skal udregne summen (eller i Yatzy
unders&oslash;ge antallet af par, tre ens osv.).</P>
<P CLASS="western">En l&oslash;sning er at skabe andre, mere
overordnede objekter, som tager sig af detaljerne. I vores tilf&aelig;lde
kan man definere en Rafleb&aelig;ger-klasse, som er bekvem at bruge
fra hovedprogrammet og som har terningerne og holder styr p&aring;
dem. Her er UML-klassediagrammet: 
</P>
<P ALIGN=CENTER STYLE="margin-top: 0.11cm; margin-bottom: 0.11cm"><IMG SRC="bog5_html_m1a5c0843.gif" NAME="Object1"></P>
<P ALIGN=CENTER STYLE="margin-top: 0.11cm; margin-bottom: 0.11cm"><FONT SIZE=2 STYLE="font-size: 9pt"><I>Et
rafleb&aelig;ger indeholder terninger.</I></FONT></P>
<P ALIGN=CENTER STYLE="margin-top: 0.11cm; margin-bottom: 0.11cm"><FONT SIZE=2 STYLE="font-size: 9pt"><I>Pilen
symboliserer <B>har-relation</B>: Et Raflebaeger har 0 til * (flere)
terninger.</I></FONT></P>

<P CLASS="western">Pilen fra rafleb&aelig;ger-klassen til
Terning-klassen repr&aelig;senterer en <B>har</B>-relation. Med 'har'
menes, at referencerne til Terning-objekterne kendes af
rafleb&aelig;ger-objektet (her via en ArrayList). Terning-objekterne
kendes ikke n&oslash;dvendigvis af hovedprogrammet.</P>

<P CLASS="western" STYLE="">Rafleb&aelig;geret
har metoderne ryst(), der kaster alle terningerne, sum(), der
udregner summen af terningernes v&aelig;rdier, og
antalDerViser(), der fort&aelig;ller, hvor mange terninger. der har
en given v&aelig;rdi (f.eks. hvor mange terninger, der viser 6 &oslash;jne).</P>
<PRE CLASS="kode-western">import java.util.*;

public class Raflebaeger
{
<I>  /** listen af terninger, der er i rafleb&aelig;geret */</I>
<B>  public ArrayList&lt;Terning&gt; terninger;</B>

<B>  public Raflebaeger(int antalTerninger)</B>
  {
    terninger = new ArrayList&lt;Terning&gt;();
    for (int i=0; i&lt;antalTerninger; i++)
    {
      Terning t;
      t = new Terning();
      tilf&oslash;j(t);
    }
  }

<I>  /** l&aelig;gger en terning i b&aelig;geret */</I>
<B>  public void tilf&oslash;j(Terning t)</B>
  {
    terninger.add(t);
  }

<I>  /** ryster b&aelig;geret, s&aring; alle terningerne bliver 'kastet' og f&aring;r en ny v&aelig;rdi */</I>
<B>  public void ryst()</B>
  {
    for (Terning t : terninger) 
    {
      t.kast();
    }
  }

<I>  /** finder s<SPAN STYLE="font-weight: medium">ummen af alle terningernes v&aelig;rdier */</SPAN></I>
<B>  public int sum()</B>
  {
    int resultat=0;
    for (Terning t : terninger) 
    {
      resultat = resultat + t.v&aelig;rdi;
    }
    return resultat;
  }

<I>  /** finder antallet af terninger, der viser en bestemt v&aelig;rdi */</I>
<B>  public int antalDerViser(int v&aelig;rdi)</B>
<SPAN STYLE="font-weight: medium">  </SPAN>{
    int resultat;
    resultat = 0;
    for (Terning t : terninger) 
    {
      if (t.v&aelig;rdi==v&aelig;rdi) 
      {
        resultat = resultat + 1;
      }
    }
    return resultat;
  }

<I>  /** beskriver b&aelig;gerets indhold som en streng */</I>
<B>  public String toString()</B>
  {<SPAN STYLE="font-weight: medium"><I>// (listens toString() kalder toString() p&aring; hver terning)</I></SPAN>
    return terninger.toString();
  }
}</PRE>

<P CLASS="western" STYLE="">Herunder er et
lille program, der spiller med tre terninger, indtil man f&aring;r
netop to seksere:</P>
<PRE CLASS="kode-western">public class ToSeksere
{
  public static void main(String[] arg)
  {  
    Raflebaeger b&aelig;ger;
    boolean toSeksere;
    int antalFors&oslash;g;

    <B>b&aelig;ger = new Raflebaeger(3)</B>;<I>   // opret et b&aelig;ger med 3 terninger</I>
    <B>toSeksere=false</B>;
    antalFors&oslash;g = 0;
    <B>while (toSeksere==false)</B>
    {
      <B>b&aelig;ger.ryst()</B>;              <I>// kast alle terningerne</I>
      System.out.print(&quot;B&aelig;ger: &quot; + b&aelig;ger + &quot; sum: &quot; + <B>b&aelig;ger.sum()</B>);
      System.out.println(&quot; Antal 6'ere: &quot;+b&aelig;ger.antalDerViser(6)
                       + &quot; antal 5'ere: &quot;+b&aelig;ger.antalDerViser(5));
<B>      if (b&aelig;ger.antalDerViser(6) == 2)</B>
<B>      {</B>
<B>        toSeksere = true;</B>
<B>      }</B>
      antalFors&oslash;g++;
    }
    System.out.println(&quot;Du fik to seksere efter &quot;+ antalFors&oslash;g+&quot; fors&oslash;g.&quot;);
  }
}</PRE>
<HR>
<PRE CLASS="kode-western">B&aelig;ger: [4, 4, 4] sum: 12 Antal 6'ere: 0 antal 5'ere: 0
B&aelig;ger: [5, 5, 6] sum: 16 Antal 6'ere: 1 antal 5'ere: 2
B&aelig;ger: [2, 5, 6] sum: 13 Antal 6'ere: 1 antal 5'ere: 1
B&aelig;ger: [4, 2, 4] sum: 10 Antal 6'ere: 0 antal 5'ere: 0
B&aelig;ger: [6, 4, 1] sum: 11 Antal 6'ere: 1 antal 5'ere: 0
B&aelig;ger: [6, 6, 4] sum: 16 Antal 6'ere: 2 antal 5'ere: 0
Du fik to seksere efter 6 fors&oslash;g.</PRE><P CLASS="western">
Linjen:</P>
<PRE CLASS="kode-western">    b&aelig;ger = new Raflebaeger(3);</PRE><P CLASS="western">
opretter et rafleb&aelig;ger med tre terninger i.</P>
<H3 CLASS="western">4.5.2 <a name='afsn4.5.2'></a>Opgaver</H3>
<OL>
  <LI><P CLASS="western">Skriv et program, der vha. et Raflebaeger
  rafler med fire terninger, indtil der sl&aring;s tre eller fire
  6'ere. Udskriv antal &oslash;jne for hver terning.</P>
  <LI><P CLASS="western">Skriv et program, der vha. et Raflebaeger
  rafler med 12 terninger og udskriver terningernes v&aelig;rdier,
  summen af v&aelig;rdierne og hvor mange 6'ere der kom.</P>
  <LI><P CLASS="western">Skriv et simpelt Yatzy-spil med fem
  terninger. Man kaster &eacute;n gang og ser, om man har et par, to
  par, tre ens, hus (et par og tre ens, f.eks. 25225), fire ens eller
  fem ens.</P>
</OL>
<P CLASS="western" STYLE="margin-left: 0.5cm">Udvid Raflebaeger, s&aring;
man kan sp&oslash;rge, om der er fire ens, med en fireEns()-metode:</P>
<PRE CLASS="kode-western" STYLE="margin-left: 0.5cm">  public boolean fireEns()
  { 
    ... 
  } </PRE><P CLASS="western" STYLE="margin-left: 0.5cm">
Lav tilsvarende de andre metoder (toEns(), treEns(), toPar(),
hus()...).<BR>(vink: G&oslash;r flittigt brug af
antalDerViser()-metoden)</P>
<P CLASS="western" STYLE="margin-left: 0.5cm">Ret toString()-metoden,
s&aring; den fort&aelig;ller, om der var fem ens, hus eller lignende.
</P>
<P CLASS="western" STYLE="margin-left: 0.5cm">Lav et program (en
klasse med en main()-metode), der rafler et Raflebaeger et par gange
og skriver dets indhold ud. Her er et eksempel p&aring;, hvordan
uddata kunne se ud:</P>
<PRE CLASS="kode-western">1 4 4 3 4  : Tre ens
4 2 1 6 6  : Et par
2 6 2 2 6  : Hus
5 2 3 6 4  : Ingenting
2 3 4 5 4  : Et par
6 5 2 6 2  : To par
6 6 2 2 6  : Hus</PRE><H2 CLASS="western">
4.6 <a name='afsn4.6'></a>N&oslash;gleordet this</SPAN></H2>
<P CLASS="western">Nogle gange kan et objekt have brug for at
referere til sig selv. Det g&oslash;res med <B>this</B>-n&oslash;gleordet,
der ligner (og bruges som) en variabel<A CLASS="sdfootnoteanc" NAME="sdfootnote6anc" HREF="#sdfootnote6sym"><SUP>6</SUP></A>.</P>
<BLOCKQUOTE CLASS="definition-western">this refererer til det objekt,
man er i</BLOCKQUOTE>
<P CLASS="western"><SPAN ID="Ramme2" STYLE="float: right; width: 3.91cm; height: 5.96cm; border: none; padding: 0cm; background: #ffffff">
  <P ALIGN=CENTER STYLE="margin-top: 0.11cm; margin-bottom: 0.11cm"><IMG SRC="bog5_html_m1b0f285.gif" NAME="Objekt8" ALIGN=LEFT><BR CLEAR=LEFT><FONT SIZE=2 STYLE="font-size: 9pt"><I><B>this</B>
  virker som en variabel , inde i objektet, der peger p&aring;
  objektet selv (b er en variabel, der peger p&aring; objektet udefra)</I></FONT></P>
</SPAN>L&aelig;s igen definitionen af Boks2. I dens s&aelig;tM&aring;l()-metode
brugte vi andre variabelnavne for parametrene (nemlig lgd, b og h)
end objektvariablerne (l&aelig;ngde, bredde og h&oslash;jde). Vi kan
altid f&aring; fat i objektets variabler med this, s&aring; vi kunne
ogs&aring; have brugt de samme variabelnavne:
</P>
<PRE CLASS="kode-western" STYLE="; ">import java.util.*;
public class Boks2medThis
{
  private double l&aelig;ngde;
  private double bredde;
  private double h&oslash;jde;

  public void s&aelig;tM&aring;l(double l&aelig;ngde, double bredde, double h&oslash;jde)
  {
    if (l&aelig;ngde&lt;=0 || bredde&lt;=0 || h&oslash;jde&lt;=0) 
    {
       System.out.println(&quot;Ugyldige m&aring;l. Bruger standardm&aring;l.&quot;);
      <B>this</B>.l&aelig;ngde = 10.0;
      <B>this</B>.bredde = 10.0;
      <B>this</B>.h&oslash;jde  = 10.0;
    } else {
      <B>this</B>.l&aelig;ngde = l&aelig;ngde;
      <B>this</B>.bredde = bredde;
      <B>this</B>.h&oslash;jde  = h&oslash;jde;
    }
  }

  public double volumen()
  {
    return bredde*h&oslash;jde*l&aelig;ngde; 
  }

  public void f&oslash;jTilListe(ArrayList l)
  {
    l.add(<B>this</B>);
  }
}</PRE><P CLASS="western" STYLE="">
I s&aelig;tM&aring;l() er der nu to s&aelig;t variabler med samme
navn. 
</P>
<P CLASS="western">Java v&aelig;lger da altid den variabel, der er
&quot;t&aelig;ttest p&aring;&quot;, dvs. f.eks. 'l&aelig;ngde'
svarer til parametervariablen l&aelig;ngde. For at f&aring; fat
i objektvariablen skal vi bruge 'this.l&aelig;ngde'. 
</P>
<P CLASS="western">Derfor skal vi skrive:</P>
<PRE CLASS="kode-western">      this.l&aelig;ngde = l&aelig;ngde;</PRE><P CLASS="western">
for at tildele objektets l&aelig;ngde-variabel den nye v&aelig;rdi.</P>
<P CLASS="western">En anden anvend<SPAN STYLE="font-weight: medium">else
af this e</SPAN>r, n&aring;r et objekt har brug for at give en
reference til sig selv til et andet objekt. Normalt ville vi tilf&oslash;je
en boks til en liste med:</P>
<PRE CLASS="kode-western">  ArrayList l = new ArrayList()
  Boks2medThis b = new Boks2medThis();
  l.add(b);</PRE><P CLASS="western">
Med metoden f&oslash;jTilListe() kan vi i stedet for bede b om at
tilf&oslash;je sig selv: 
</P>
<PRE CLASS="kode-western">  b.f&oslash;jTilListe(l);</PRE><P CLASS="western">
Vi vil senere (i Spiller-klassen i matadorspillet i kapitlet om
nedarvning) se et eksempel p&aring; dette, hvor det er en fordel i
praksis.</P>
<H2 CLASS="western">4.7 <a name='afsn4.7'></a>Ekstra eksempler</SPAN></H2>
<P CLASS="western">Dette afsnit giver nogle ekstra eksempler, der
repeterer stoffet i kapitlet.</P>
<H3 CLASS="western">4.7.1 <a name='afsn4.7.1'></a>En n-sidet terning</H3>
<P CLASS="western">Det normale er en 6-sidet terning, men der findes
ogs&aring; 4-, 8- 12- og 20-sidede. Klassen nedenfor beskriver en
generel n-sidet terning. 
</P>
<PRE CLASS="kode-western"><I>/** En klasse der beskriver 4-, 8- 12- og 20-sidede terninger */</I>
public class NSidetTerning
{
<I>  /** hvor mange sider har terningen (normalt 6) */</I>
<B>  private int sider;</B>

<I>  /** den side p&aring; terningen, der vender opad lige nu */</I>
<B>  private int v&aelig;rdi;</B>

<I>  /** konstrukt&oslash;r der opretter en standardterning med 6 sider */</I>
<B>  public NSidetTerning ()</B>
  {
    sider = 6;
    kast(); // s&aelig;t v&aelig;rdi til noget
  }

<I>  /** konstrukt&oslash;r der opretter en terning med et vist antal sider */</I>
<B>  public NSidetTerning (int antalSider)</B>
  {
    if (antalSider &gt;= 3) sider = antalSider;
    else sider = 6;
    kast();
  }


<I>  /** kaster terningen, s&aring; den f&aring;r en anden v&aelig;rdi */</I>
<B>  public void kast ()</B>
  {
<I>    // find en tilf&aelig;ldig side</I>
    double tilf&aelig;ldigtTal = Math.random();
    v&aelig;rdi = (int) (tilf&aelig;ldigtTal * <B>sider</B> + 1);
  }

<I>  /** giver antallet af &oslash;jne p&aring; den side p&aring; terningen, der vender opad */</I>
<B>  public int hentV&aelig;rdi ()</B>
  {
    return v&aelig;rdi;
  }

<I>  /** &aelig;ndrer terningen til at vende en bestemt side opad */</I>
<B>  public void s&aelig;tV&aelig;rdi (int nyV&aelig;rdi)</B>
  {
    if (nyV&aelig;rdi &gt; 0 &amp;&amp; nyV&aelig;rdi &lt;= sider) v&aelig;rdi = nyV&aelig;rdi;
    else System.out.println(&quot;Ugyldig v&aelig;rdi&quot;);
  }

<I>  /** giver en beskrivelse af terningen som en streng.</I>
<I>      Hvis den ikke har 6 sider udskrives ogs&aring; antal af sider */</I>
<B>  public String toString ()</B>
  {
    String svar = &quot;&quot;+v&aelig;rdi;  <I>// v&aelig;rdi som streng, f.eks. &quot;4&quot;</I>
    if (sider!= 6) svar = svar+&quot;(&quot;+sider+&quot;s)&quot;;
    return svar;
  }
}</PRE><P CLASS="western">
Vi har ladet antallet af sider og v&aelig;rdien v&aelig;re private og
lavet metoden hentV&aelig;rdi(), som kan bruges udefra. Der er ogs&aring;
en s&aelig;tV&aelig;rdi()-metode, mens antallet af sider ikke kan
&aelig;ndres udefra, n&aring;r f&oslash;rst terningen er skabt.</P>
<P CLASS="western" ALIGN=CENTER><IMG SRC="bog5_html_m6fcc078b.gif" NAME="Objekt59" ALIGN=BOTTOM></P>
<P CLASS="western">Her er et program til at afpr&oslash;ve klassen
med:</P>
<PRE CLASS="kode-western">public class BenytNSidetTerning
{
  public static void main(String[] arg)
  {
    NSidetTerning t = new NSidetTerning(); <I>// sekssidet terning</I>

    System.out.println(&quot;t viser nu &quot;+t.hentV&aelig;rdi()+&quot; &oslash;jne&quot;);

    NSidetTerning t6 = new NSidetTerning(6); <I>// sekssidet terning</I>
    NSidetTerning t4 = new NSidetTerning(4); <I>// firesidet terning</I>
    NSidetTerning t12 = new NSidetTerning(12); <I>// tolvsidet terning</I>

    System.out.println(&quot;t4 er &quot;+t4); <I>// t4.toString() kaldes implicit</I>
    t4.kast();
    System.out.println(&quot;t4 er nu &quot;+t4);
    t4.kast();

    System.out.println(&quot;terninger: &quot;+t+&quot; &quot;+t6+&quot; &quot;+t4+&quot; &quot;+t12);
    t.kast();
    t12.kast();
    System.out.println(&quot;terninger: &quot;+t+&quot; &quot;+t6+&quot; &quot;+t4+&quot; &quot;+t12);

    for (int i=0; i&lt;5; i++) 
    {
      t.kast();
      t6.kast();
      t4.kast();
      t12.kast();
      System.out.println(&quot;kast &quot;+i+&quot;: &quot;+t+&quot; &quot;+t6+&quot; &quot;+t4+&quot; &quot;+t12);
      if (t.hentV&aelig;rdi() == t6.hentV&aelig;rdi())
      {
        System.out.println(&quot;t og t6 er ens!&quot;);
      }
    }
  }
}</PRE>
<HR>
<PRE CLASS="kode-western">t viser nu 6 &oslash;jne
t4 er 4(4s)
t4 er nu 1(4s)
terninger: 6 1 4(4s) 5(12s)
terninger: 6 1 4(4s) 3(12s)
kast 0: 3 1 4(4s) 2(12s)
kast 1: 1 6 4(4s) 11(12s)
kast 2: 1 1 4(4s) 5(12s)
t og t6 er ens!
kast 3: 3 6 4(4s) 3(12s)
kast 4: 3 2 2(4s) 6(12s)</PRE><H3 CLASS="western" STYLE="">
4.7.2 <a name='afsn4.7.2'></a>Personer</H3>
<P CLASS="western">Lad os lave en klasse til at repr&aelig;sentere en
person. Hvert person-objekt skal have et fornavn, et efternavn
og en alder. N&aring;r man opretter en ny Person, skal man angive
disse data, f.eks.: new Person(&quot;Jacob&quot;,&quot;Nordfalk&quot;,30),
s&aring; vi definerer en konstrukt&oslash;r med disse parametre.</P>
<P CLASS="western">Vi definerer ogs&aring;, at hver person har
metoden toString(), der returnerer en streng med personens
oplysninger af formen &quot;Jacob Nordfalk (30 &aring;r)&quot;.</P>
<P CLASS="western">Desuden har vi metoden pr&aelig;sentation(), der
skriver oplysningerne p&aelig;nt ud til sk&aelig;rmen som &quot;Jeg
hedder Jacob og jeg er 30 &aring;r&quot;. Denne metode returnerer
ikke noget, men skriver i stedet hilsenen ud til sk&aelig;rmen
(personer under 5 &aring;r siger bare &quot;agyyy!&quot;)</P>
<P CLASS="western">Til sidst kunne man forestille sig, at en person
kan hilse p&aring; en anden person (metoden hils()). Det afh&aelig;nger
af alderen, hvordan man hilser. En person p&aring; over 60 &aring;r
vil hilse p&aring; Jacob med &quot;Goddag hr Nordfalk&quot;, mens en
yngre bare vil sige &quot;Hej Jacob&quot;.</P>
<PRE CLASS="kode-western">import java.util.*;
public class Person
{
<B>  public String fornavn;</B>
<B>  public String efternavn;</B>
<B>  public int alder;</B>
  public ArrayList&lt;Konto&gt; konti; <I>// bruges senere</I>

<B>  public Person(String fornavnP, String efternavnP, int alderP)</B>
  {
    fornavn = fornavnP;
    efternavn = efternavnP;
    alder = alderP;
    konti = new ArrayList&lt;Konto&gt;(); <I>// bruges senere</I>
  }

<B>  public String toString()</B>
  {
    return fornavn+&quot; &quot;+efternavn+&quot; (&quot;+alder+&quot; &aring;r)&quot;;
  }

<B>  public void pr&aelig;sentation()</B>
  {
    if (alder &lt; 5) System.out.println(&quot;agyyy!&quot;);
    else System.out.println(&quot;Jeg hedder &quot;+fornavn+&quot; og jeg er &quot;+alder+&quot; &aring;r.&quot;);
  }

<B>  public void hils(Person andenPerson)</B>
  {
    if (alder &lt; 5) System.out.print(&quot;ma ma.. &quot;);
    else if (alder &lt; 60) System.out.print(&quot;Hej &quot;+<B>andenPerson.fornavn</B>+&quot;. &quot;);
    else  System.out.print(&quot;Goddag hr. &quot;+<B>andenPerson.efternavn</B>+&quot;. &quot;);

    pr&aelig;sentation();
  }
}</PRE><P CLASS="western">
Bem&aelig;rk, at Person-objektet har to andre objekter, nemlig to
strenge. Selvom man ikke plejer at tegne strenge med i
klassediagrammer, har vi alligevel taget dem med for at illustrere,
at der faktisk ogs&aring; eksisterer en <B>har</B>-relation mellem
disse to klasser.</P>


<P ALIGN=CENTER STYLE="margin-top: 0.11cm; margin-bottom: 0.11cm"><IMG SRC="bog5_html_m52629942.gif" NAME="Objekt60" ALIGN=BOTTOM></P>
<P ALIGN=CENTER STYLE="margin-top: 0.11cm; margin-bottom: 0.11cm"><FONT SIZE=2 STYLE="font-size: 9pt"><I>En
Person har to String-objekter. Disse er undtagelsesvist ogs&aring;
vist</I></FONT></P>
<P CLASS="western">L&aelig;g ogs&aring; m&aelig;rke til, hvordan vi
fra hils()-metoden kalder pr&aelig;sentation(). Lad os pr&oslash;ve
at oprette tre personer og lade dem pr&aelig;sentere sig og derp&aring;
hilse p&aring; hinanden:</P>
<PRE CLASS="kode-western">public class BenytPerson
{
  public static void main(String[] arg)
  {
    Person j, k, l;
    j = new Person(&quot;Jacob&quot;, &quot;Nordfalk&quot;, 30);
    k = new Person(&quot;Kai&quot;, &quot;Lund&quot;, 86);
    l = new Person(&quot;Lars&quot;, &quot;Holm&quot;, 2);

    System.out.println(&quot;Vi har oprettet &quot;+j+&quot;, &quot;+k+&quot; og &quot;+l);
    j.pr&aelig;sentation();
    k.pr&aelig;sentation();
    l.pr&aelig;sentation();
    j.hils(k);
    k.hils(j);
    l.hils(j);
  }
}</PRE>
<HR>
<PRE CLASS="kode-western">Vi har oprettet Jacob Nordfalk (30 &aring;r), Kai Lund (86 &aring;r) og Lars Holm (2 &aring;r)
Jeg hedder Jacob og jeg er 30 &aring;r.
Jeg hedder Kai og jeg er 86 &aring;r.
agyyy!
Hej Kai. Jeg hedder Jacob og jeg er 30 &aring;r.
Goddag hr. Nordfalk. Jeg hedder Kai og jeg er 86 &aring;r.
ma ma.. agyyy!</PRE><P CLASS="western">
I linjen</P>
<PRE CLASS="kode-western">    x.hils(y);</PRE><P CLASS="western">
er det x-variablens person (Jacob), der hilser p&aring; y-variablens
person. Da x-variablens person er under 60, vil den uformelle hilsen
&quot;Hej Kai&quot; blive brugt. I linjen under er det lige omvendt.</P>
<H3 CLASS="western">4.7.3 <a name='afsn4.7.3'></a>Design af klasser</H3>
<P CLASS="western">I <a href='kapitel22.jsp'>kapitel 22</a>, Objektorienteret analyse og design
kan du l&aelig;se mere om, hvordan man designer sit program, d.v.s.
v&aelig;lger hvilke klasser, der skal defineres, hvilke metoder de
skal have og hvilke relationer, der skal v&aelig;re mellem
objekterne.</P>
<H2 CLASS="western" STYLE="">4.8 <a name='afsn4.8'></a>Test dig
selv</SPAN></H2>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP3/kapitel4.jsp#afsn4.8">
  <input type='checkbox' name='vis' value='4.8'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='4.8'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H2 CLASS="western">4.9 <a name='afsn4.9'></a>Resum&eacute;</SPAN></H2>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP3/kapitel4.jsp#afsn4.9">
  <input type='checkbox' name='vis' value='4.9'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='4.9'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western" STYLE="">4.9.1 <a name='afsn4.9.1'></a>Formen af
en klasse</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP3/kapitel4.jsp#afsn4.9.1">
  <input type='checkbox' name='vis' value='4.9.1'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='4.9.1'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">4.9.2 <a name='afsn4.9.2'></a>Formen af en metode</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP3/kapitel4.jsp#afsn4.9.2">
  <input type='checkbox' name='vis' value='4.9.2'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='4.9.2'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H2 CLASS="western">
4.10 <a name='afsn4.10'></a>Opgaver</SPAN></H2>
<P CLASS="western">Husk at lave sm&aring; main()-programmer, der
afpr&oslash;ver de ting, du programmerer.</P>
<OL>
  <LI><P CLASS="western">Lav en klasse, der repr&aelig;senterer en
  bil. En bil har en farve, et antal k&oslash;rte kilometer og en
  nypris. Defin&eacute;r metoderne:<BR><FONT FACE="Courier, monospace"><FONT SIZE=1 STYLE="font-size: 8pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: #d9d9d9">public
  void k&oslash;r(int antalKilometer) <I>// opdaterer antal k&oslash;rte
  kilometre          </I><BR>public double pris()                <I>//
  giver den vurderede salgspris            </I><BR>public String
  toString()            <I>// giver en beskrivelse af bilen           
  </I></SPAN></SPAN></FONT></FONT>
  </P>
  <LI><P CLASS="western">Udbyg Bil-klassen med en liste, der husker,
  hvilke personer, der sidder i bilen lige nu. Defin&eacute;r f&oslash;lgende
  metoder p&aring; Bil-klassen og afpr&oslash;v klassen.<BR><FONT FACE="Courier, monospace"><FONT SIZE=1 STYLE="font-size: 8pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: #d9d9d9">public
  void enS&aelig;tterSigInd(Person p)<I>// kaldes n&aring;r person
  s&aelig;tter sig ind i bilen</I><BR>public String hvemSidderIBilen()
    <I>// giver en beskrivelse af personerne i bilen</I><BR>public
  void alleStigerUd()         <I>// kaldes, n&aring;r alle stiger ud
  af bilen       </I></SPAN></SPAN></FONT></FONT>
  </P>
</OL>
<OL START=3>
  <LI><P CLASS="western">Lav et program, der holder styr p&aring; en
  musiksamling. Opret en klasse, der repr&aelig;senterer en
  udgivelse (int &aring;r, String navn, String gruppe, String
  pladeselskab). Programmet skal huske listen over udgivelser og kunne
  udskrive den.</P>
</OL>
<H3 CLASS="western">4.10.1 <a name='afsn4.10.1'></a>BlueJ</H3>
<P CLASS="western">Udviklingsv&aelig;rkt&oslash;jet BlueJ, der er
beskrevet i <a href='kapitel1.jsp#afsn1.3.5'>afsnit 1.3.5</a>, er meget velegnet til at forst&aring;
begreberne behandlet i dette kapitel bedre. Har du installeret BlueJ,
kan du hente bogens eksempler som BlueJ-projekter (de ligger p&aring;
adressen <A CLASS="western" HREF="http://javabog.dk/OOP/kode/">http://javabog.dk/OOP/kode/</A>).
</P>
<UL>
  <LI><P CLASS="western">Pak ZIP-filen med BlueJ-projekterne ud, start
  BlueJ og &aring;bn projektet kapitel_04_bokse. <BR>Projektet viser
  klasserne Boks2, BenytBoks2, Boks3 og BenytBoks3.<BR><IMG SRC="bog5_html_m47a5a839.png" NAME="Grafik29" ALIGN=BOTTOM HSPACE=4 BORDER=0></P>
  <LI><P CLASS="western">H&oslash;jreklik derefter p&aring; Boks2 og
  opret et objekt ved at v&aelig;lge 'new Boks2()'.<BR>Objektet dukker
  op som en r&oslash;d kasse nederst. H&oslash;jreklik og kald
  volumen()-metoden.</P>
  <LI><P CLASS="western">H<IMG SRC="bog5_html_1424416c.png" NAME="Grafik32" ALIGN=RIGHT HSPACE=4 BORDER=0>&oslash;jreklik
  p&aring; objektet og kald s&aelig;tM&aring;l(). S&aelig;t
  parametrene til f.eks. 2, 3 og 3 og klik OK. <BR>Unders&oslash;g
  objektets variabler (h&oslash;jreklik og v&aelig;lg <I>Inspect</I>).
  Kald derefter volumen() igen og tjek resultatet.</P>
  <LI><P CLASS="western">H&oslash;jreklik p&aring; BenytBoks2 og v&aelig;lg
  main() for at k&oslash;re programmet.</P>
  <LI><P CLASS="western">&Aring;bn nu Boks3 og se p&aring;
  kildekoden.<BR>Skift derefter til 'Interface' for at se javadoc for
  klassen.</P>
</UL>
<P CLASS="western">N&aring;r du har leget med Boks-klasserne som de
er, s&aring; pr&oslash;v at &aelig;ndre i klasserne (ret i koden).
Pr&oslash;v derefter de andre BlueJ-projekter.</P>
<H3 CLASS="western" STYLE="">4.10.2 <a name='afsn4.10.2'></a>Fejlfinding</H3>
<OL>
  <LI><P CLASS="western">Der er 2 fejl i koden nedenfor. Find dem og
  ret dem. Kig eventuelt p&aring; afsnittene om formen af en
  klasse og formen af en metode ovenfor.</P>
</OL>
<PRE CLASS="ikke-javakode-western">public class Fejlfinding1
{
  private int a = 5;
  private String b;
  private c String;
  {
}</PRE>
<OL START=2>
  <LI><P CLASS="western">Der er 3 fejl i koden nedenfor. Find dem og
  ret dem.</P>
</OL>
<PRE CLASS="ikke-javakode-western">public class Fejlfinding2
{
  private String b;

  public Fejlfinding2() {
    return b;
  }

  b = &quot;Hej&quot;;

  public Fejlfinding2(String c) {
    b = c
  }
 }
}</PRE>
<OL START=3>
  <LI><P CLASS="western">Der er 9 fejl i koden nedenfor. Find dem, ret
  dem og begrund rettelserne.</P>
</OL>
<PRE CLASS="ikke-javakode-western">public class Fejlfinding4
{
  private int a = 5;
  private String b;

  public void x1(int y)
  {
    y = a;
  }

  a = 2;

  public Fejlfind(int a) {
    a = 4;
    String = &quot;goddag&quot;;
  }

  public x2(int y)
  {
    a = y*2;
  }

  public int x3(y int)
  {
    b = y;
  }

  public void x4(int y)
  {
    return 5;
  }</PRE>

<OL START=4>
  <LI><P CLASS="western">Der er 9 fejl i koden nedenfor. Find dem og
  ret dem.</P>
</OL>
<PRE CLASS="ikke-javakode-western">import java.util.*;

public class Fejlfinding3
{
  public String l = 'hej';
  public string etLangtVariabelnavn;
  public arrayList v2;
  public INT v3;
  public Double v4 = 5.3;
  public v5;
  public int vi = 5.3;
  public ArrayList vi3 = &quot;xx&quot;;
  public String vi5 = new String(Hej);
}</PRE>
<OL START=5>
  <LI><P CLASS="western">Der er 6 fejl i koden nedenfor. Find dem og
  ret dem.</P>
</OL>
<PRE CLASS="ikke-javakode-western">public class Fejlfinding5
{
  private int a = 5
  public void x1(int y)   {
    a = y;                         }
}
  public void x2(int y) <I>// fejlmeddelelse: 'class' or 'interface' expected</I>
  {
    a = y*2*x1;

  public int x3(int y)
  {
    a = y*x2();
  }
  }

  public void x4(int y)
  {
    x4 = 8;
  }
}</PRE>
<OL START=6>
  <LI><P CLASS="western">Find s&aring; mange fejl du kan i koden
  nedenfor og ret dem.</P>
</OL>
<PRE CLASS="ikke-javakode-western">public class Fejlfinding6
{
  public int m()
  {
    System.out.println(&quot;Metode m blev kaldt.&quot;);

  public void m2()
  {
    String s = &quot;Metode m2 blev kaldt.&quot;
    System.out.println(s);
    return s;
  }

  public m3()
  {
    System.out.println(&quot;Metode m3 blev kaldt.&quot;);
  }

  public void m4(int)
  {
    System.out.println(&quot;m4 fik parameter &quot;+p);
  }

  public void m5(p1, p2, p3)
  {
    System.out.println(&quot;m5 fik &quot;+p1+&quot; og &quot;+p2+&quot; og &quot;+p3);
    System.out.println(&quot;s er: &quot;+s);
    String s = p2.toUpperCase();
  }
}</PRE><H2 CLASS="western" STYLE="">
4.11 <a name='afsn4.11'></a>Avanceret</SPAN></H2>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP3/kapitel4.jsp#afsn4.11">
  <input type='checkbox' name='vis' value='4.11'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='4.11'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">4.11.1 <a name='afsn4.11.1'></a>Bankkonti</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP3/kapitel4.jsp#afsn4.11.1">
  <input type='checkbox' name='vis' value='4.11.1'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='4.11.1'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">
4.11.2 <a name='afsn4.11.2'></a>Opgaver</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP3/kapitel4.jsp#afsn4.11.2">
  <input type='checkbox' name='vis' value='4.11.2'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='4.11.2'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  
<DIV ID="sdfootnote1">
  <P CLASS="sdfootnote-western"><A CLASS="sdfootnotesym" NAME="sdfootnote1sym" HREF="#sdfootnote1anc">1</A>Vi
  vil senere se, at s&aring;kaldte klassevariabler (static) ogs&aring;
  erkl&aelig;res her.</P>
</DIV>
<DIV ID="sdfootnote2">
  <P CLASS="sdfootnote-western"><A CLASS="sdfootnotesym" NAME="sdfootnote2sym" HREF="#sdfootnote2anc">2</A>N&aring;r
  programudf&oslash;relsen g&aring;r ind i metoden, oprettes de lokale
  variabler. De nedl&aelig;gges igen, n&aring;r metoden returnerer. 
  </P>
</DIV>
<DIV ID="sdfootnote3">
  <P CLASS="sdfootnote-western"><A CLASS="sdfootnotesym" NAME="sdfootnote3sym" HREF="#sdfootnote3anc">3</A>Man
  kan godt lave en klasse, der b&aring;de har en main()-metode og som
  der oprettes objekter ud fra, men det kan v&aelig;re forvirrende for
  en begynder at blande de to ting sammen.</P>
</DIV>
<DIV ID="sdfootnote4">
  <P CLASS="sdfootnote-western"><A CLASS="sdfootnotesym" NAME="sdfootnote4sym" HREF="#sdfootnote4anc">4</A>Skriver
  man ingenting, svarer det til public (inden for samme pakke - se
  <a href='kapitel6.jsp#afsn6.9'>afsnit 6.9</a>).</P>
</DIV>
<DIV ID="sdfootnote5">
  <P CLASS="sdfootnote-western"><A CLASS="sdfootnotesym" NAME="sdfootnote5sym" HREF="#sdfootnote5anc">5</A>Kommentarerne
  med /** og */ g&oslash;r, at man automatisk kan generere
  dokumentation ud fra klassen (af samme form som standardklassernes
  dokumentation). Javadoc er behandlet i <a href='kapitel2.jsp'>kapitel 2</a> i &quot;Videreg&aring;ende
  programmering i Java&quot;, der kan l&aelig;ses p&aring;
  http://javabog.dk/VP.</P>
</DIV>
<DIV ID="sdfootnote6">
  <P CLASS="sdfootnote-western"><A CLASS="sdfootnotesym" NAME="sdfootnote6sym" HREF="#sdfootnote6anc">6</A>Man
  kan dog ikke tildele this en anden v&aelig;rdi.</P>
</DIV>

<a href='http://javabog.dk/'>javabog.dk</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel3.jsp'>&lt;&lt; forrige</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='indhold.jsp'>indhold</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel5.jsp'>n&aelig;ste &gt;&gt;</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kode/'>programeksempler</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='../index_OOP.html'>om bogen</a>
<hr>
<font size=-2>http://javabog.dk/ - <b></b> af Jacob Nordfalk.
<br>
  Licens og kopiering under <a href='http://www.linuxbog.dk/licens.html'>&Aring;ben Dokumentlicens</a> (&Aring;DL)
  hvor intet andet er nvnt (82% af vrket).
</font>
<br>
nsker du at se de sidste 18% af dette vrk (199974 tegn)
skal du kbe bogen. S fr du pne figurer og layout, stikordsregister og en trykt bog med i kbet.
<!-- netlser: Wget/1.10, autoHent: true  -->
     

</body>
</html>
